<?php
// To run this code longer
ini_set('max_execution_time', 18000);

// Run when form is submitted 
if(isset($_POST['start'])){
	$start = $_POST['start'];
	$stop = $_POST['stop'];
	getData($start, $stop);
	echo "Done!";
}

// Gets data from geopeitus.ee 
function getData($start, $stop){
	$file = 'coordinates3.txt'; // file to put results
	file_put_contents($file, ""); // empties previous file
	$result="";
	$limit = $stop;
	for ($i = $start; $i <= $limit; $i++) {
		$content = file_get_contents('http://www.geopeitus.ee/aare/'.$i);
		// Takes only regular, multy and puzzle treasures
		if (strpos($content,'<h1><font color=red>!!! Arhiveeritud !!!</font></h1>') === false && strpos($content,'</a><br/></td></tr><tr><td>Tüüp: <b>Sündmusaare</b>') === false && strpos($content,'</a><br/></td></tr><tr><td>Tüüp: <b>Veebikaamera</b> ') === false
			 && strpos($content,'</a><br/></td></tr><tr><td>Tüüp: <b>Asukohata (tagurpidi) aare</b> ') === false  && strpos($content,'</a><br/></td></tr><tr><td>Tüüp: <b>Virtuaalne aare</b> ') === false) {
				preg_match('/class=\"left\" \/\>\<\/a\>\n(.*?)\<\/h1\>/', $content, $treasureName); // tries to get treasure name
				if (sizeof($treasureName) > 1) {
					$name = $treasureName[1];
					$name = str_replace("; ", ", ", $name);
					preg_match('/dd\.dddd\: \<b\>(.*?)\<\/b\>/m', $content, $coordinate); // finds treasures coordinates
					if (sizeof($coordinate) > 1) {
						preg_match_all('/\<div class=\"evpic\" id=\"pic(.*?)\"\>\<a target/', $content, $treasureImage); // looks for user posted images
						$images = "";
						if(sizeof($treasureImage[1]) > 0){						
							for($c=0; $c<sizeof($treasureImage[1]); $c++){
								$images .= $treasureImage[1][$c].",";
							}
						}
						preg_match_all('/\<div class=\"cachepic\" id=\"pic(.*?)\"\>\<a target/', $content, $treasureImage2); // looks for authors images
						if(sizeof($treasureImage2[1]) > 0){
							for($c=0; $c<sizeof($treasureImage2[1]); $c++){
								$images .= $treasureImage2[1][$c].",";
							}
						}else if($images==""){ // if no images is found, show default image
							$images = "1771,";
						}	
						$images = substr($images, 0, -1); // remove last coma
						$type=0;
						preg_match('/td\>Tüüp: \<b\>(.*?)\<\/b\> /', $content, $treasureType); // get treasure type
						if (sizeof($treasureType) > 1) {
							switch ($treasureType[1]) {
								case "Tavaline aare":
									$type=1;
									break;
								case "Multiaare":
									$type=2;
									break;
							}
						}
						$hiding=0;
						preg_match('/\<b\>Raskusaste:\<\/b\> peidukoht (.*?), maastik /', $content, $hidingPlace); // get hiding place level
						if (sizeof($hidingPlace) > 1) {
							$hiding=$hidingPlace[1];
						}
						$terrain=0;
						preg_match('/, maastik (.*?) \<b\>Suurus:\<\/b\> /', $content, $terrainLevel); // get terrian level
						if (sizeof($terrainLevel) > 1) {
							$terrain=$terrainLevel[1];
						}
						$size="normaalne";
						preg_match('/ \<b\>Suurus:\<\/b\> (.*?)\<\/td\>\<\/tr\>\<\/table\>/', $content, $treasureSize); // get trasure size
						if (sizeof($treasureSize) > 1) {
							$size=$treasureSize[1];
						}
						$coordinates = $coordinate[1];
						$coordinates = str_replace(",", ".", $coordinates);
						$coordinates = str_replace(" ", ";", $coordinates);				
						$result = $name.";".$coordinates.";".$images.";".$type.";".$hiding.";".$terrain.";".$size.";".$i.";";
						// if this treasure is not in file put it there
						if(strpos(file_get_contents($file), ";".$i.";")=== false){
							file_put_contents($file, $result, FILE_APPEND);
						}
					}
				}
		}
//		sleep(1);
		usleep(500000); // wait 0,5 secondsbefore making new query
	}
	// removes last semicolon from file
	$fileContent = file_get_contents($file);
	file_put_contents($file, substr($fileContent, 0, -1));
}

?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Get data</title>
    </head>
    
    <body>
        <form name="data" method="post" action="getdata.php">
            <p>
                <label for="start">Start: </label>
                <input type="text" name="start" id="start" required>
            </p>
            <p>
                <label for="stop">Stop: </label>
                <input type="text" name="stop" id="stop" required>
            </p>
            <p>
            	<input type="submit" name="submit" id="submit" value="Submit">
            </p>
        </form>
        <p><a href="index.php" title="Go To Map" target="_self">To map</a></p>
    </body>

</html> 